/************************************************************************************************************\

Module Name:    AudioAudioEncModule.h

Description:    Module for Liberatus audio encoder.

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_AUDIOENCODERMODULE_H
#define INC_AUDIOENCODERMODULE_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"
#include "CommonUtils.h"
#include "ModuleThread.h"
#include "ModuleLink.h"
#include "LAudioCodec.h"


// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Structure:      AudioEncModule

Description:    Module for Liberatus audio encoder.

\************************************************************************************************************/
typedef struct tagAudioEncModule
{
    LAudioEncoder_Handle        hEncoder;               // Encoder handle.
    ModuleThread                oCpuThreadIn;           // Input CPU thread.
    ModuleThread                oCpuThreadOut;          // Output CPU thread.
    ModuleLinkInput             oInLink;                // Input module link.
    ModuleLink                  oOutLink;               // Output module link.
    MUINT64                     uiElapsedTimeUsec;      // Elapse time elpase since the first completed NALU in usec.
    MUINT64                     uiCopiedBytes;          // Number of bytes copied to the encoder.
    MUINT                       uiEncodedBuffers;       // Number of encoded buffers.
    MUINT                       uiMaxEncodedBufSize;    // Maximum size of an encoded buffer.
    MUINT16                     uiAudioSpecificConfig;  // Audio specific config.
    MCHAR8                      szModuleName[16];

} AudioEncModule;

#define AudioEncModule_Construct {/*.hEncoder               =*/ MNULL, \
                                  /*.oCpuThreadIn           =*/ ModuleThread_Construct, \
                                  /*.oCpuThreadOut          =*/ ModuleThread_Construct, \
                                  /*.oInLink                =*/ ModuleLinkInput_Construct, \
                                  /*.oOutLink               =*/ ModuleLink_Construct, \
                                  /*.uiElapsedTimeUsec      =*/ 0, \
                                  /*.uiCopiedBytes          =*/ 0, \
                                  /*.uiEncodedBuffers       =*/ 0, \
                                  /*.uiMaxEncodedBufSize    =*/ 0, \
                                  /*.uiAudioSpecificConfig  =*/ 0, \
                                  /*.szModuleName           =*/ "" }

// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------
LStatus AudioEncMod_Init(
            AudioEncModule*             poAEncMod,
            LDevice_Handle              hDevice,
            MUINT                       uiOutBufferCount,
            LBuffer_Type                eOutBufferType,
            LAudioCodec_SamplingRate    eSamplingRate,
            LAudioCodec_ChannelCfg      eChannelCfg,
            LAudioCodec_AACStreamFormat eStreamFormat,
            LAudioCodec_AACProfile      eProfile,
            LAudioCodec_AACQualityLevel eQualityLevel,
            MBOOL32                     bUseTns,
            MUINT32                     uiBitRate);

void    AudioEncMod_Cleanup(
            AudioEncModule*     poAEncMod);

LStatus AudioEncMod_Start(
            AudioEncModule*     poAEncMod);

void    AudioEncMod_Stop(
            AudioEncModule*     poAEncMod);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_AUDIOENCODERMODULE_H
